from time import sleep
from Adafruit_I2C import Adafruit_I2C
from Adafruit_MCP230xx import Adafruit_MCP230XX
import smbus

class Adafruit_CharLCDPlate:
    OUTPUT = 0
    INPUT = 1
    # commands
    LCD_CLEARDISPLAY     	= 0x01
    LCD_RETURNHOME 		= 0x02
    LCD_ENTRYMODESET 		= 0x04
    LCD_DISPLAYCONTROL 		= 0x08
    LCD_CURSORSHIFT 		= 0x10
    LCD_FUNCTIONSET 		= 0x20
    LCD_SETCGRAMADDR 		= 0x40
    LCD_SETDDRAMADDR 		= 0x80

    # flags for display entry mode
    LCD_ENTRYRIGHT 		= 0x00
    LCD_ENTRYLEFT 		= 0x02
    LCD_ENTRYSHIFTINCREMENT 	= 0x01
    LCD_ENTRYSHIFTDECREMENT 	= 0x00

    # flags for display on/off control
    LCD_DISPLAYON 		= 0x04
    LCD_DISPLAYOFF 		= 0x00
    LCD_CURSORON 		= 0x02
    LCD_CURSOROFF 		= 0x00
    LCD_BLINKON 		= 0x01
    LCD_BLINKOFF 		= 0x00

    # flags for display/cursor shift
    LCD_DISPLAYMOVE 		= 0x08
    LCD_CURSORMOVE 		= 0x00

    # flags for function set
    LCD_8BITMODE 		= 0x10
    LCD_4BITMODE 		= 0x00
    LCD_1LINE 			= 0x80
    LCD_2LINE 			= 0xC0
    LCD_3LINE  = 0x94
    LCD_4LINE  = 0xD4

    LCD_5x10DOTS 		= 0x04
    LCD_5x8DOTS 		= 0x00
 
    def __init__(self, busnum=0, pin_rs=0, pin_e=1, pins_db=[2,3,4,5],pin_rw=6):
        self.pin_rs = pin_rs
        self.pin_e = pin_e
        self.pin_rw = pin_rw
        self.pins_db = pins_db

	self.mcp = Adafruit_MCP230XX(busnum = busnum, address = 0x20, num_gpios = 8)

        self.mcp.config(self.pin_e, self.OUTPUT)
        self.mcp.config(self.pin_rs,  self.OUTPUT)
        self.mcp.config(self.pin_rw,  self.OUTPUT)
        self.mcp.output(self.pin_rw, 0)
        self.mcp.output(self.pin_e, 0)
        
        for pin in self.pins_db:
            self.mcp.config(pin,  self.OUTPUT)

	self.write4bits(0x33) # initialization
	self.write4bits(0x32) # initialization
        self.write4bits(0x28) # 2 line 5x7 matrix
	self.write4bits(0x0C) # turn cursor off 0x0E to enable cursor
	self.write4bits(0x06) # shift cursor right

	self.displaycontrol = self.LCD_DISPLAYON | self.LCD_CURSOROFF | self.LCD_BLINKOFF
	self.displayfunction = self.LCD_4BITMODE | self.LCD_1LINE | self.LCD_5x8DOTS
	self.displayfunction |= self.LCD_4LINE

	""" Initialize to default text direction (for romance languages) """
	self.displaymode =  self.LCD_ENTRYLEFT | self.LCD_ENTRYSHIFTDECREMENT
	self.write4bits(self.LCD_ENTRYMODESET | self.displaymode) #  set the entry mode

    def begin(self, cols, lines):
        if (lines > 1):
            self.numlines = lines
            self.displayfunction |= self.LCD_2LINE
        self.currline = 0
        self.clear()

    def home(self):
        self.write4bits(self.LCD_RETURNHOME) # set cursor position to zero
        self.delayMicroseconds(2000) # this command takes a long time!

    def clear(self):
        self.write4bits(self.LCD_CLEARDISPLAY) # command to clear display
        self.delayMicroseconds(2000)	# 2000 microsecond sleep, clearing the display takes a long time

    def setCursor(self, col, row):
        self.row_offsets = [ 0x00, 0x40, 0x14, 0x54 ]
        if ( row > self.numlines ): 
		    row = self.numlines - 1 # we count rows starting w/0
        self.write4bits(self.LCD_SETDDRAMADDR | (col + self.row_offsets[row]))

    def noDisplay(self): 
        """ Turn the display off (quickly) """
        self.displaycontrol &= ~self.LCD_DISPLAYON
        self.write4bits(self.LCD_DISPLAYCONTROL | self.displaycontrol)

    def display(self):
        """ Turn the display on (quickly) """
        self.displaycontrol |= self.LCD_DISPLAYON
        self.write4bits(self.LCD_DISPLAYCONTROL | self.displaycontrol)

    def noCursor(self):
        """ Turns the underline cursor on/off """
        self.displaycontrol &= ~self.LCD_CURSORON
        self.write4bits(self.LCD_DISPLAYCONTROL | self.displaycontrol)

    def cursor(self):
        """ Cursor On """
        self.displaycontrol |= self.LCD_CURSORON
        self.write4bits(self.LCD_DISPLAYCONTROL | self.displaycontrol)

    def noBlink(self):
	""" Turn on and off the blinking cursor """
        self.displaycontrol &= ~self.LCD_BLINKON
        self.write4bits(self.LCD_DISPLAYCONTROL | self.displaycontrol)

    def createChar(self, location, bitmap):
        self.write4bits(self.LCD_SETCGRAMADDR | ((location & 7) << 3))
        for i in range(8):
            self.write4bits(bitmap[i], True)
        self.write4bits(self.LCD_SETDDRAMADDR)

    def write4bits(self, bits, char_mode=False):
        """ Send command to LCD """
        bits=bin(bits)[2:].zfill(8)
        self.mcp.output(self.pin_rs, char_mode)

        for i in range(4):
            if bits[i] == "1":
                self.mcp.output(self.pins_db[::-1][i], True)
            else:
                self.mcp.output(self.pins_db[::-1][i], False)
        self.pulseEnable()

        for i in range(4,8):
            if bits[i] == "1":
                self.mcp.output(self.pins_db[::-1][i-4], True)
            else:
                self.mcp.output(self.pins_db[::-1][i-4], False)
        self.pulseEnable()

    def delayMicroseconds(self, microseconds):
        seconds = microseconds / 1000000	# divide microseconds by 1 million for seconds
        sleep(seconds)

    def pulseEnable(self):
        self.mcp.output(self.pin_e, True)
        self.delayMicroseconds(1)		# 1 microsecond pause - enable pulse must be > 450ns 
        self.mcp.output(self.pin_e, False)

    def message(self, text):
        """ Send string to LCD. Newline wraps to second line"""
        for char in text:
                 self.write4bits(ord(char),True)

if __name__ == '__main__':

    lcd = Adafruit_CharLCDPlate(busnum = 0)
    lcd.clear()
    lcd.message("Adafruit RGB LCD\nPlate w/Keypad!")
    sleep(1)
